Notebook[{

Cell[CellGroupData[{
Cell["\<\

conformal transformation of Klein-Gordon equation with xConf\
\>", "Subtitle",
 FontSize->24,ExpressionUUID->"b73ea991-a1e7-4945-91d0-4054ec287b18"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<xAct`xConf`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"678b56c2-43ca-42da-a7c6-2d1dc4257ac4"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"f057c0a0-dc69-45b0-ac4e-4cd8a987e014"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"66182d31-77aa-4f5d-bedd-b33afdced5e8"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"122ff64a-5171-4034-b503-d6003deacf91"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"7c9c64d2-e16a-4b85-ac04-ddfcbb2c5025"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"e682c725-9617-4628-a590-c7b099f9edbc"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"c9f7d762-4d8b-4143-aa36-0b37b12416d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"3dab7ddd-9ac5-4909-b163-1c2748071a79"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"d1e4dad2-d193-4cfc-bb3b-24ca11fd0283"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"eea27654-e9d9-49d8-88f7-e23e92c43fcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xConf`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.0.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "4", ",", "4"}], "}"}]}],
  SequenceForm["Package xAct`xConf`  version ", "0.0.1", ", ", {2025, 4, 4}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"936cb1d7-1d7f-443c-9782-c96b9c76d02b"],

Cell[BoxData["\<\"CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"2031aa8d-e798-46d2-a94b-a1be0c65f196"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"f3a08732-ab74-459c-ae57-8546378a9521"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"62190547-c077-4e7f-ae64-ecf66f9802f6"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"b0731399-2480-470c-9cc7-fa9380c64664"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$PrePrint", 
   "\[InvisibleSpace]", "\<\" assigned value \"\>", "\[InvisibleSpace]", 
   "ScreenDollarIndices"}],
  SequenceForm[
  "** Variable ", $PrePrint, " assigned value ", 
   xAct`xTensor`ScreenDollarIndices],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"b1587240-cc28-495a-aeb3-8e643951a8e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "AllowUpperDerivatives", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ContractMetric",
    "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`AllowUpperDerivatives, " of ", 
   xAct`xTensor`ContractMetric, " changed from ", False, " to ", True],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"f6e3a6ce-b02e-40eb-90cc-5b470b4a61a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "UseMetricOnVBundle", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ToCanonical", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "All", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "None"}],
  SequenceForm[
  "** Option ", xAct`xTensor`UseMetricOnVBundle, " of ", 
   xAct`xTensor`ToCanonical, " changed from ", All, " to ", None],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"29dec630-49e0-4e43-88f6-2e79fdb4eccf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", "dim", "]"}]], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"01ff8c5e-de8b-4a21-9d11-ba76d0610745"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "dim", "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", 
   "constant symbol ", $CellContext`dim, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"0e6f06eb-af11-4065-aec5-334555784cdf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "dim", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Mu]", ",", "\[Nu]", 
     ",", "\[Lambda]", ",", "\[Sigma]"}], "}"}]}], "]"}], "\n", 
 RowBox[{
  RowBox[{"DefMetric", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}]}], "]"}], ",", "CD", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<;\>\"", ",", "\"\<\[Del]\>\""}], "}"}], ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"e5a250ec-cb66-4862-b7ba-440ac45c6456"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`M,
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"69c107f9-50a3-417c-a547-6f1ed1e5b32a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"4fe14231-68da-4c7b-9f5a-871637197773"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"ef430c0e-a7f4-4ed0-bf0b-7f90b35ed161"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"840bc56f-901f-4b10-bde5-f1e489913bcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"cd3773e7-7b5e-428f-bc52-ed3855f5c4d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"61dbb4c0-5c16-40da-9a56-1af1731b83f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"4069e1c7-c68e-47fb-9527-41ca7d643765"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"9f434291-bc12-45c0-95de-26f9d8516156"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"2c57ce12-eda8-4ebb-91fb-63d12f319464"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"1daa2f86-d735-40b4-9a5f-2dc32b173c90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"eed0399c-ffa8-4979-bce2-ed4cf59829bc"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"a3e2c7c8-6aed-4ec7-b3e2-0a317762bea4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"199bef99-7d34-45c4-97b4-efc354fe3360"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"818d465f-9a2f-4106-b79a-c9015f5fe133"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"61691603-ece0-4fb4-9f83-e5eee33cbb21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"d1303e09-82c5-4320-be66-d93e54671387"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["dim",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`dim,
    Editable->False]}],
  SequenceForm[
  "** DefCovD:  Computing RiemannToWeylRules for dim ", $CellContext`dim],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"817efb4e-d945-4086-8714-4899816d4ec7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["dim",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`dim,
    Editable->False]}],
  SequenceForm[
  "** DefCovD:  Computing RicciToTFRicci for dim ", $CellContext`dim],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"68295ddc-bd14-4415-aabe-3c1c86e1c0b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["dim",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`dim,
    Editable->False]}],
  SequenceForm[
  "** DefCovD:  Computing RicciToEinsteinRules for dim ", $CellContext`dim],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"311308d9-d754-40bd-926c-d182da2801d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"2ff9fdcf-60c6-4043-9293-e787cba2c885"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["We define a conformally related metric and a scalar field", \
"Subsubsection",ExpressionUUID->"205e852e-c304-48a5-b494-7870a9263bb2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConformalMetric", "[", 
  RowBox[{"g", ",", "S", ",", 
   RowBox[{"FrameColor", "->", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"726e6cf1-44ea-4e27-acf5-7c4b0174cef3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Choosing color \"\>", "\[InvisibleSpace]", 
   TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>,
    "RGBColorSwatchTemplate"], 
   "\[InvisibleSpace]", "\<\" for this conformal frame.\"\>"}],
  SequenceForm["Choosing color ", 
   RGBColor[1, 0, 0], " for this conformal frame."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"954f04c8-d521-4a66-be65-5498ebac2153"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"015a27a4-8878-444d-ba90-abced19d090b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"gS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Sigma]$2678"}], ",", 
     RowBox[{"-", "\[Sigma]$2679"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`gS2[-$CellContext`\[Sigma]$2678, -$CellContext`\[Sigma]$2679],
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"866f047a-8b22-431a-9b84-75e76078f9bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"InvgS2", "[", 
    RowBox[{"\[Sigma]$2678", ",", "\[Sigma]$2679"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Metric is frozen!\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "inverse metric tensor ", 
   $CellContext`InvgS2[$CellContext`\[Sigma]$2678, \
$CellContext`\[Sigma]$2679], ". ", "Metric is frozen!"],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"fbb32188-a56e-4129-ac97-76c17df97e69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilongS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilongS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"7a785bfb-9c8f-47da-8749-f7b80022f20d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDgS2", "[", 
    RowBox[{"-", "\[Sigma]$2678"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDgS2[-$CellContext`\[Sigma]$2678], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"64a1710a-bc8c-4890-9ae2-bd6adcbcfdb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCDgS2[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"5e78225c-c121-42c1-a24a-5a11b542f3f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDgS2[$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"13a24dcc-b964-4d13-bfae-1411697296ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannDownCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannDownCDgS2[-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"3166a99b-9841-4271-ae85-3b5a3154ac7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", "\[Lambda]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], $CellContext`\[Lambda]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"6d6dad8c-9fae-4640-bcbc-c9d4c0aafa39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"bc15c8c1-d3e0-48ec-8e95-ab6a3f6b6a07"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"14ffd7f7-1514-4737-b4a7-bcef14e23675"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCDgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCDgS2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"f8983fcd-5876-4794-941c-bb8a579ce81e"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"ea9a783e-f56c-4e8c-a8d4-5f682beaca9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"6d28478e-7142-449b-b376-7dafbc4c8289"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"5f0d548d-55ae-454a-86bc-2a67c7066850"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"90d6ff46-b78f-40c9-97d0-a18ac730e5b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCDgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCDgS2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"4757963a-ac42-454c-a2f4-325dfccc3333"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["dim",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`dim,
    Editable->False]}],
  SequenceForm[
  "** DefCovD:  Computing RiemannToWeylRules for dim ", $CellContext`dim],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"d74c0194-c17b-471e-8819-503826a62828"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["dim",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`dim,
    Editable->False]}],
  SequenceForm[
  "** DefCovD:  Computing RicciToEinsteinRules for dim ", $CellContext`dim],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"9dc6cec9-b948-463f-8e23-ba71cb73a9ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetgS2[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"9ce20d0b-6bef-434d-bea8-2adb149bfd30"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "gS2", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`gS2], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"2048976d-8214-42ed-b682-4ca4a6f7189b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "g", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`g], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"ab54fb0a-9950-4a1a-bccd-7c3e592f9a80"]
}, Open  ]]
}, Open  ]],

Cell["We define  a scalar field with a conformal weight s", \
"Text",ExpressionUUID->"7b58f9c5-4e76-4885-bb9c-f21c02a2e7aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"\[Phi]", "[", "]"}], ",", "M"}], "]"}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"2dd00f10-bcae-4fb8-87df-30253da18d24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Phi]", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Phi][], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"6cb07de9-1de4-4eda-a6ac-655799f9f118"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", "s", "]"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"1b3aae41-1b01-4e43-a262-65ad089d9d16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", "s", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", 
   "constant symbol ", $CellContext`s, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[7]:=",ExpressionUUID->"f59a3a3f-f74e-4897-91fc-bceb0783c215"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConformalWeight", "[", "\[Phi]", "]"}], "=", "s"}], 
  ";"}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"6142394f-fbb4-4c61-a662-ab7cad904418"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{"\[Phi]", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"c98fa3a0-2a02-495c-998a-c3df55a2e125"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDCDgS2[$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[9]:=",ExpressionUUID->"c476ff03-7e60-49be-9363-2308643746c1"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s,
    Editable->False]], " ", 
  InterpretationBox[
   StyleBox["\[Phi]",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Phi][],
   Editable->False]}]], "Output",
 CellLabel->"Out[9]=",ExpressionUUID->"916139d4-b5db-4add-bad2-a8bc1cf4f7d5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{"dim", ",", "Integers"}], "]"}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"s", ",", "Integers"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"223b1808-6b2d-4c91-8a5d-3bd0d29910d0"],

Cell["The simple Klein Gordon equation is", \
"Text",ExpressionUUID->"b1e4654a-1f50-4855-a5a7-cdb5ced7d392"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KG", "=", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Mu]"}], "]"}], "[", 
   RowBox[{
    RowBox[{"CD", "[", "\[Mu]", "]"}], "[", 
    RowBox[{"\[Phi]", "[", "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"01ba35c5-ce08-4cec-b4b6-0d0903c728e5"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[Del]", "\[Mu]"], 
    SuperscriptBox["\[Del]", "\[Mu]"], "\[Phi]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[-$CellContext`\[Mu]][
   $CellContext`CD[$CellContext`\[Mu]][
    $CellContext`\[Phi][]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[10]=",ExpressionUUID->"c10f09c5-4882-4a31-a796-2119d4869a29"]
}, Open  ]],

Cell["\<\
Klein - Gordon equation is not conformally invariant (eq. D.12 of Wald\
\[CloseCurlyQuote]s book (1984) on General Relativity)\
\>", "Text",ExpressionUUID->"03947b1c-eb52-42c5-a875-2e543f27e88e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConformalTransformation", "[", 
     RowBox[{"g", ",", "gS2"}], "]"}], "[", "KG", "]"}], "//", "NoScalar"}], "//",
   "ContractMetric"}]], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"57963171-baa4-4961-b3c1-1c3ad08f2f65"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s,
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s,
      Editable->False]}]], " ", 
   InterpretationBox[
    StyleBox["\[Phi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Phi][],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], 
      SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`S[]]],
    Editable->False]}], "+", 
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s,
      Editable->False]}]], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], 
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`\[Phi][]]],
    Editable->False]}], "-", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s,
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s,
      Editable->False]}]], " ", 
   InterpretationBox[
    StyleBox["\[Phi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Phi][],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox["dim",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`dim,
    Editable->False], " ", 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s,
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s,
      Editable->False]}]], " ", 
   InterpretationBox[
    StyleBox["\[Phi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Phi][],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False]}], "+", 
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s,
     Editable->False], "2"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s,
      Editable->False]}]], " ", 
   InterpretationBox[
    StyleBox["\[Phi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Phi][],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s,
      Editable->False]}]], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[Phi][]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox["dim",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`dim,
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s,
      Editable->False]}]], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[Phi][]],
    Editable->False]}], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s,
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s,
      Editable->False]}]], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[Phi][]],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[12]=",ExpressionUUID->"2ac62810-c53a-4ae7-b0d3-ca00033dc74e"]
}, Open  ]],

Cell["\<\
Let us define a modified KG equation as in D.13 of Walds\[CloseCurlyQuote] \
book.\
\>", "Text",ExpressionUUID->"b5a59b47-34dd-4f99-a1c1-124c1646c11e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KG2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "\[Mu]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"CD", "[", "\[Mu]", "]"}], "[", 
     RowBox[{"\[Phi]", "[", "]"}], "]"}], "]"}], "-", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"dim", "-", "2"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"4", 
       RowBox[{"(", 
        RowBox[{"dim", "-", "1"}], ")"}]}], ")"}]}], 
    RowBox[{"RicciScalarCD", "[", "]"}], 
    RowBox[{"\[Phi]", "[", "]"}]}]}]}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"b483f544-d597-4858-a6f1-bfeec51c4f55"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       InterpretationBox[
        StyleBox["dim",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dim,
        Editable->False]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[Del]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarCD[],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox["\[Phi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Phi][],
      Editable->False]}], 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       InterpretationBox[
        StyleBox["dim",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dim,
        Editable->False]}], ")"}]}]]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "\[Mu]"], 
     SuperscriptBox["\[Del]", "\[Mu]"], "\[Phi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`\[Mu]][
    $CellContext`CD[$CellContext`\[Mu]][
     $CellContext`\[Phi][]]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[13]=",ExpressionUUID->"8609aefb-d73a-4e37-866e-3307d1d95915"]
}, Open  ]],

Cell["\<\
If we choose s = 1 - dim/2, then this modified KG equation is conformally \
invariant\
\>", "Text",ExpressionUUID->"13904828-565b-4763-9c8a-7654205476dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpecialsRule", "=", 
   RowBox[{"{", 
    RowBox[{"s", "->", 
     RowBox[{"1", "-", 
      RowBox[{"dim", "/", "2"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"ab5ad78b-357a-4bd6-9b5e-308ea2732f11"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ConformalTransformation", "[", 
        RowBox[{"g", ",", "gS2"}], "]"}], "[", "KG2", "]"}], "/.", 
      "SpecialsRule"}], ")"}], "//", "NoScalar"}], "//", "ContractMetric"}], "//",
   "ToCanonical"}], "\[IndentingNewLine]", 
 RowBox[{"KG2transformed", "=", 
  RowBox[{"Simplify", "[", "%", "]"}]}]}], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"d25522ef-4eda-4153-8d8e-599ea1df255c"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", "\[Del]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCD[],
     Editable->False], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      FractionBox[
       InterpretationBox[
        StyleBox["dim",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dim,
        Editable->False], "2"]}]], " ", 
    InterpretationBox[
     StyleBox["\[Phi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Phi][],
     Editable->False]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox["dim",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`dim,
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", "\[Del]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCD[],
     Editable->False], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      FractionBox[
       InterpretationBox[
        StyleBox["dim",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dim,
        Editable->False], "2"]}]], " ", 
    InterpretationBox[
     StyleBox["\[Phi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Phi][],
     Editable->False]}], 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False]}], ")"}]}]], "+", 
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     FractionBox[
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False], "2"]}]], " ", 
   InterpretationBox[
    StyleBox["\[Phi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Phi][],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], 
      SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`S[]]],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      FractionBox[
       InterpretationBox[
        StyleBox["dim",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dim,
        Editable->False], "2"]}]], " ", 
    InterpretationBox[
     StyleBox["\[Phi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Phi][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], 
       SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`CD[$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    InterpretationBox[
     StyleBox["dim",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`dim,
     Editable->False]}]], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox["dim",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`dim,
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     FractionBox[
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False], "2"]}]], " ", 
   InterpretationBox[
    StyleBox["\[Phi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Phi][],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], 
      SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`S[]]],
    Editable->False]}], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    InterpretationBox[
     StyleBox["dim",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`dim,
     Editable->False], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      FractionBox[
       InterpretationBox[
        StyleBox["dim",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dim,
        Editable->False], "2"]}]], " ", 
    InterpretationBox[
     StyleBox["\[Phi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Phi][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], 
       SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`CD[$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["dim",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`dim,
      Editable->False], "2"], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      FractionBox[
       InterpretationBox[
        StyleBox["dim",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dim,
        Editable->False], "2"]}]], " ", 
    InterpretationBox[
     StyleBox["\[Phi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Phi][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], 
       SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`CD[$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False]}], ")"}]}]], "+", 
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     FractionBox[
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False], "2"]}]], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], 
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`\[Phi][]]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "3"}], "-", 
     FractionBox[
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False], "2"]}]], " ", 
   InterpretationBox[
    StyleBox["\[Phi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Phi][],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False]}], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      FractionBox[
       InterpretationBox[
        StyleBox["dim",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dim,
        Editable->False], "2"]}]], " ", 
    InterpretationBox[
     StyleBox["\[Phi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Phi][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    InterpretationBox[
     StyleBox["dim",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`dim,
     Editable->False]}]], "+", 
  RowBox[{
   FractionBox["3", "2"], " ", 
   InterpretationBox[
    StyleBox["dim",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`dim,
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "3"}], "-", 
     FractionBox[
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False], "2"]}]], " ", 
   InterpretationBox[
    StyleBox["\[Phi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Phi][],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{"7", " ", 
    InterpretationBox[
     StyleBox["dim",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`dim,
     Editable->False], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      FractionBox[
       InterpretationBox[
        StyleBox["dim",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dim,
        Editable->False], "2"]}]], " ", 
    InterpretationBox[
     StyleBox["\[Phi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Phi][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False]}], ")"}]}]], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["dim",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`dim,
     Editable->False], "2"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "3"}], "-", 
     FractionBox[
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False], "2"]}]], " ", 
   InterpretationBox[
    StyleBox["\[Phi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Phi][],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`S[]],
    Editable->False]}], "-", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["dim",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`dim,
      Editable->False], "2"], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      FractionBox[
       InterpretationBox[
        StyleBox["dim",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dim,
        Editable->False], "2"]}]], " ", 
    InterpretationBox[
     StyleBox["\[Phi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Phi][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["dim",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`dim,
      Editable->False], "3"], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      FractionBox[
       InterpretationBox[
        StyleBox["dim",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dim,
        Editable->False], "2"]}]], " ", 
    InterpretationBox[
     StyleBox["\[Phi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Phi][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False]}], ")"}]}]]}]], "Output",
 CellLabel->"Out[15]=",ExpressionUUID->"ba1f5970-c091-4838-96cc-0e7fe0ba3c62"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     FractionBox[
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False], "2"]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          InterpretationBox[
           StyleBox["dim",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`dim,
           Editable->False]}], ")"}], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{"R", "[", "\[Del]", "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RicciScalarCD[],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox["\[Phi]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Phi][],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        InterpretationBox[
         StyleBox["dim",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`dim,
         Editable->False]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "\[Alpha]"], 
         SuperscriptBox["\[Del]", "\[Alpha]"], "\[Phi]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`CD[$CellContext`\[Alpha]][
         $CellContext`\[Phi][]]],
       Editable->False]}]}], ")"}]}], 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     InterpretationBox[
      StyleBox["dim",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`dim,
      Editable->False]}], ")"}]}]]], "Output",
 CellLabel->
  "Out[16]=",ExpressionUUID->"557cc4ba-9700-43e6-8d99-d835e2701656"]
}, Open  ]],

Cell["This is D.14 of Wald\[CloseCurlyQuote]s book.", \
"Text",ExpressionUUID->"0ca8e7dc-beb4-417e-b638-b11c283bc841"],

Cell["\<\
And we check indeed that if the modified KG vanishes, then the conformally \
transformed version also vanishes (D.14 of Wald\[CloseCurlyQuote]s book).\
\>", "Text",ExpressionUUID->"e3b36d1f-e182-48b4-a423-e6f344bb8d23"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"Box\[Phi]", "[", "]"}], ",", "M"}], "]"}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"142579aa-4cff-4797-a883-0c1766f79a0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Box\[Phi]", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Box\[Phi][], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[17]:=",ExpressionUUID->"066856a9-cfab-45aa-b159-460ddba5e8f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RuleToBox", "=", 
  RowBox[{"IndexRule", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "\[Mu]_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"CD", "[", "\[Mu]_", "]"}], "[", 
      RowBox[{"\[Phi]", "[", "]"}], "]"}], "]"}], ",", 
    RowBox[{"Box\[Phi]", "[", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"d5544da7-6a15-40fc-bcca-3600bcf4bd5c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"HoldPattern", "[", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", 
       UnderscriptBox["\[Mu]", "_"]], 
      SuperscriptBox["\[Del]", 
       UnderscriptBox["\[Mu]", "_"]], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-Pattern[$CellContext`\[Mu], 
       Blank[]]][
     $CellContext`CD[
      Pattern[$CellContext`\[Mu], 
       Blank[]]][
      $CellContext`\[Phi][]]],
    Editable->False], "]"}], "\[RuleDelayed]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    InterpretationBox[
     StyleBox["Box\[Phi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Box\[Phi][],
     Editable->False]}], "]"}]}]], "Output",
 CellLabel->
  "Out[18]=",ExpressionUUID->"b6172c30-de0b-4cae-bf8d-fa59e7643f69"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RuleKG2", "=", 
  RowBox[{"IndexSolve", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"KG2", "/.", "RuleToBox"}], ")"}], "==", "0"}], ")"}], ",", 
    RowBox[{"Box\[Phi]", "[", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"6f2d83c1-2808-4f3a-abf8-931c6b20a0c0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    InterpretationBox[
     StyleBox["Box\[Phi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Box\[Phi][],
     Editable->False], "]"}], "\[RuleDelayed]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         InterpretationBox[
          StyleBox["dim",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`dim,
          Editable->False]}], ")"}], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{"R", "[", "\[Del]", "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RicciScalarCD[],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox["\[Phi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Phi][],
        Editable->False]}], 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         InterpretationBox[
          StyleBox["dim",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`dim,
          Editable->False]}], ")"}]}]]}], "]"}]}], "}"}]], "Output",
 CellLabel->
  "Out[19]=",ExpressionUUID->"ee33695b-a206-4fdd-af41-4673f17b2f9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"KG2transformed", "/.", "RuleToBox"}], "\[IndentingNewLine]", 
 RowBox[{"%", "/.", "RuleKG2"}]}], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"fb05547c-5bd8-4a9f-9bfb-f0788e06c051"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     FractionBox[
      InterpretationBox[
       StyleBox["dim",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dim,
       Editable->False], "2"]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        InterpretationBox[
         StyleBox["dim",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`dim,
         Editable->False]}], ")"}], " ", 
      InterpretationBox[
       StyleBox["Box\[Phi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Box\[Phi][],
       Editable->False]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        InterpretationBox[
         StyleBox["dim",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`dim,
         Editable->False]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{"R", "[", "\[Del]", "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciScalarCD[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Phi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Phi][],
       Editable->False]}]}], ")"}]}], 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     InterpretationBox[
      StyleBox["dim",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`dim,
      Editable->False]}], ")"}]}]]], "Output",
 CellLabel->"Out[20]=",ExpressionUUID->"32aba19b-001a-4dce-b022-908f44260877"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[21]=",ExpressionUUID->"09e0c881-434e-4057-a364-55b701e3ec88"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1222, 723},
WindowMargins->{{Automatic, 74}, {Automatic, 6}},
Visible->True,
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[{
      ButtonBox[
      "\"\[Dagger]\"", ButtonFunction :> Exit[], Appearance -> Automatic, 
       Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluatorStart"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\[RightTriangle]\"", ButtonFunction :> 
       FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateNotebook"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"EvalInit\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateInitialization"]], Evaluator -> None,
        Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"Init\"", 
       ButtonFunction :> (Module[{Utility`Toolbar`cell = NotebookSelection[
             SelectedNotebook[]], Utility`Toolbar`isInit}, 
          Utility`Toolbar`isInit = ReplaceAll[InitializationCell, 
             Options[Utility`Toolbar`cell, InitializationCell]]; If[
            TrueQ[
             Or[
             Utility`Toolbar`isInit == True, Utility`Toolbar`isInit == On]], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> False], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> True]]]; 
        Null), Appearance -> Automatic, Evaluator -> Automatic, Method -> 
       "Preemptive"], 
      ButtonBox["\"DeInit\"", ButtonFunction :> SetOptions[
         NotebookSelection[
          SelectedNotebook[]], InitializationCell -> False], Appearance -> 
       Automatic, Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"\[DeleteKey]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["DeleteGeneratedCells"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"]}, "Row", 
     DisplayFunction -> (
      RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
        "\[InvisibleSpace]", #4, "\[InvisibleSpace]", #5, 
        "\[InvisibleSpace]", #6, "\[InvisibleSpace]", #7}]& ), 
     InterpretationFunction -> (RowBox[{"Row", "[", 
        RowBox[{"{", 
          RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
          "}"}], "]"}]& )]], "DockedCell"]},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"14.1 pour Mac OS X ARM (64-bit) (July 16, 2024)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "PastelColor.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"d5a261cc-427a-495a-8802-fcb83c286279"
]

